
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  CS8416.h: functions to communicate with and configure the CS8416 digital audio receiver IC via SPI
  Written by Nicholas Vinen, 2012-2013
*/

#ifndef _CS8416_H_
#define _CS8416_H_

#include "types.h"

#define CS8416_REG_CONTROL0                 0x00
#define CS8416_REG_CONTROL1                 0x01
#define CS8416_REG_CONTROL2                 0x02
#define CS8416_REG_CONTROL3                 0x03
#define CS8416_REG_CONTROL4                 0x04
#define CS8416_REG_SERIAL_DATA_AUDIO_FORMAT 0x05
#define CS8416_REG_RCVR_ERROR_MASK          0x06
#define CS8416_REG_INTERRUPT_MASK           0x07
#define CS8416_REG_INTERRUPT_MODE_MSB       0x08
#define CS8416_REG_INTERRUPT_MODE_LSB       0x09
#define CS8416_REG_RCVR_CHNANEL_STATUS      0x0a
#define CS8416_REG_AUDIO_FORMAT_DETECT      0x0b
#define CS8416_REG_RCVR_ERROR               0x0c
#define CS8416_REG_INTERRUPT_STATUS         0x0d
#define CS8416_REG_Q_CHANNEL_SUBCODE        0x0e
#define CS8416_REG_OMCK_RMCK_RATIO          0x18
#define CS8416_REG_CHANNEL_A_STATUS         0x19
#define CS8416_REG_CHANNEL_B_STATUS         0x1e
#define CS8416_REG_BURST_PREAMBLE_PC        0x23
#define CS8416_REG_BURST_PREAMBLE_PD        0x25
#define CS8416_REG_ID_AND_VERSION           0x7f

#define CS8416_CONTROL0_TRUNC               (1<<2)
#define CS8416_CONTROL1_CHS                 (1<<0)
#define CS8416_CONTROL1_RMCKF               (1<<1)
#define CS8416_CONTROL1_HOLD_SHIFT              2
#define CS8416_CONTROL1_INT_SHIFT               4
#define CS8416_CONTROL1_MUTESAO             (1<<6)
#define CS8416_CONTROL1_SWCLK               (1<<7)
#define CS8416_CONTROL2_GPO0SEL_SHIFT           0
#define CS8416_CONTROL3_GPO1SEL_SHIFT           4
#define CS8416_CONTROL3_GPO2SEL_SHIFT           0
#define CS8416_GPO_GND                          0
#define CS8416_GPO_EMPH                         1
#define CS8416_GPO_INT                          2
#define CS8416_GPO_C                            3
#define CS8416_GPO_U                            4
#define CS8416_GPO_RERR                         5
#define CS8416_GPO_NVERR                        6
#define CS8416_GPO_RCBL                         7
#define CS8416_GPO_96KHZ                        8
#define CS8416_GPO_AUDIO                        9
#define CS8416_GPO_VLRCK                       10
#define CS8416_GPO_TX                          11
#define CS8416_GPO_VDD                         12
#define CS8416_GPO_HRMCK                       13
#define CS8416_CONTROL2_EMPH_CNTL_SHIFT         4
#define CS8416_CONTROL2_EMPH_OFF                0
#define CS8416_CONTROL2_EMPH_ON_32KHZ           1
#define CS8416_CONTROL2_EMPH_ON_44_1KHZ         2
#define CS8416_CONTROL2_EMPH_ON_48KHZ           3
#define CS8416_CONTROL2_EMPH_AUTO               4
#define CS8416_CONTROL2_DETCI               (1<<7)
#define CS8416_CONTROL4_RUN                 (1<<7)
#define CS8416_CONTROL4_RXD                 (1<<6)
#define CS8416_CONTROL4_RXSEL_SHIFT             3
#define CS8416_CONTROL4_TXSEL_SHIFT             0
#define CS8416_CHANSTATUS_AUX_MASK          (0xF0)
#define CS8416_CHANSTATUS_AUX_SHIFT             4
#define CS8416_CHANSTATUS_PRO               (1<<3)
#define CS8416_CHANSTATUS_COPY              (1<<2)
#define CS8416_CHANSTATUS_ORIG              (1<<1)
#define CS8416_CHANSTATUS_EMPH              (1<<0)
#define CS8416_SDAF_SOMS                    (1<<7)
#define CS8416_SDAF_SOSF                    (1<<6)
#define CS8416_SDAF_SORES_SHIFT                 4
#define CS8416_SDAF_SOJUST                  (1<<3)
#define CS8416_SDAF_SODEL                   (1<<2)
#define CS8416_SDAF_SOSPOL                  (1<<1)
#define CS8416_SDAF_SOLRPOL                 (1<<0)
#define CS8416_RERR_QCRC                    (1<<6)
#define CS8416_RERR_CCRC                    (1<<5)
#define CS8416_RERR_UNLOCK                  (1<<4)
#define CS8416_RERR_VALID                   (1<<3)
#define CS8416_RERR_CONF                    (1<<2)
#define CS8416_RERR_BIP                     (1<<1)
#define CS8416_RERR_PAR                     (1<<0)
#define CS8416_INT_PCCH                     (1<<6)
#define CS8416_INT_OSLIP                    (1<<5)
#define CS8416_INT_DETC                     (1<<4)
#define CS8416_INT_CCH                      (1<<3)
#define CS8416_INT_RERR                     (1<<2)
#define CS8416_INT_QCH                      (1<<1)
#define CS8416_INT_FCH                      (1<<0)
#define CS8416_AUDIO_FORMAT_PCM             (1<<6)
#define CS8416_AUDIO_FORMAT_IEC61937        (1<<5)
#define CS8416_AUDIO_FORMAT_DTS_LD          (1<<4)
#define CS8416_AUDIO_FORMAT_DTS_CD          (1<<3)
#define CS8416_AUDIO_FORMAT_DGTL_SIL        (1<<1)
#define CS8416_AUDIO_FORMAT_96KHZ           (1<<0)
#define CS8416_ID                           0x20

void CS8416_Setup();
void CS8416_HoldInReset();
void CS8416_Write_Register(unsigned char addr, unsigned char data);
unsigned char CS8416_Read_Register(unsigned char addr);
void CS8416_Write_Registers(unsigned char addr, const unsigned char* data, unsigned char num);
void CS8416_Read_Registers(unsigned char addr, unsigned char* data, unsigned char num);

bool CS8416_Verify_ID();

#endif//_CS8416_H_
